<?php
/**
 * Plugin Name: XML Sitemap Generator
 * Description: Generiere automatisch eine sitemap.xml-Datei bei jeder Änderung eines Beitrags oder einer Seite.
 * Author: Vitali Lutz
 * Author URI: https://vitali-lutz.de
 * Version: 1.0
 */

defined( 'ABSPATH' ) || exit;

/**
 * Trigger sitemap regeneration when posts or pages are saved or deleted.
 */
function vlwp_xml_sitemap_generator_register_hooks() {
    add_action( 'save_post', 'vlwp_xml_sitemap_generator_update' );
    add_action( 'delete_post', 'vlwp_xml_sitemap_generator_update' );
}
add_action( 'init', 'vlwp_xml_sitemap_generator_register_hooks' );

/**
 * Generate the sitemap.xml file and save it in the root directory.
 */
function vlwp_xml_sitemap_generator_update() {
    $home_url = home_url( '/' );
    $posts    = get_posts(
        array(
            'post_type'      => array( 'post', 'page' ),
            'post_status'    => 'publish',
            'numberposts'    => -1,
            'suppress_filters' => false,
        )
    );

    if ( empty( $posts ) ) {
        return;
    }

    $xml  = '<?xml version="1.0" encoding="UTF-8"?>' . PHP_EOL;
    $xml .= '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">' . PHP_EOL;

  foreach ( $posts as $post ) {

    // Skip drafts, pending, private, etc.
    if ( $post->post_status !== 'publish' ) {
      continue;
    }

    $url = get_permalink( $post );

    if ( ! $url ) {
      continue;
    }

    $lastmod = get_the_modified_time( 'c', $post );

    $xml .= "  <url>\n";
    $xml .= '    <loc>' . esc_url( $url ) . "</loc>\n";
    $xml .= '    <lastmod>' . esc_html( $lastmod ) . "</lastmod>\n";
    $xml .= "    <changefreq>weekly</changefreq>\n";
    $xml .= "    <priority>0.8</priority>\n";
    $xml .= "  </url>\n";
  }

    $xml .= '</urlset>';

    // Save to sitemap.xml in root directory.
    $sitemap_path = ABSPATH . 'sitemap.xml';
    file_put_contents( $sitemap_path, $xml );
}