<?php
/**
 * Plugin Name: VLWP WebP
 * Description: Automatically converts uploaded JPEG/PNG images to WebP.
 * Author: Vitali Lutz
 * Author URI: https://vitali-lutz.de
 * Version: 1.0.0
 * Requires at least: 6.0
 * Requires PHP: 7.4
 * Text Domain: vlwp-webp
 * Domain Path: /languages
 */

defined( 'ABSPATH' ) || exit;

if ( ! defined( 'vlwp_webp_version' ) ) {
	define( 'vlwp_webp_version', '1.0.0' );
}

if ( ! defined( 'vlwp_webp_plugin_file' ) ) {
	define( 'vlwp_webp_plugin_file', __FILE__ );
}

if ( ! defined( 'vlwp_webp_plugin_dir' ) ) {
	define( 'vlwp_webp_plugin_dir', plugin_dir_path( __FILE__ ) );
}

if ( ! defined( 'vlwp_webp_plugin_url' ) ) {
	define( 'vlwp_webp_plugin_url', plugin_dir_url( __FILE__ ) );
}

require_once vlwp_webp_plugin_dir . 'includes/class-vlwp-webp-core.php';
require_once vlwp_webp_plugin_dir . 'includes/class-vlwp-webp-admin.php';

register_activation_hook( __FILE__, array( 'VLWP_WebP_Admin', 'vlwp_activate' ) );

add_action( 'plugins_loaded', 'vlwp_webp_bootstrap' );

/**
 * Bootstrap the plugin.
 */
function vlwp_webp_bootstrap() {
	vlwp_webp_load_textdomain();

	VLWP_WebP_Core::vlwp_get_instance()->vlwp_init();

	if ( is_admin() ) {
		VLWP_WebP_Admin::vlwp_get_instance()->vlwp_init();
	}
}

/**
 * Load plugin textdomain.
 */
function vlwp_webp_load_textdomain() {
	load_plugin_textdomain( 'vlwp-webp', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
}