<?php
/**
 * Plugin Name: VLWP Updater
 * Description: Automatic update manager for VLWP plugins from custom repository.
 * Author: Vitali Lutz
 * Author URI: https://vitali-lutz.de
 * Version: 1.0.0
 * Requires at least: 6.0
 * Requires PHP: 7.4
 * Text Domain: vlwp-updater
 * Domain Path: /languages
 */

defined( 'ABSPATH' ) || exit;

if ( ! defined( 'vlwp_updater_version' ) ) {
	define( 'vlwp_updater_version', '1.0.0' );
}

if ( ! defined( 'vlwp_updater_plugin_file' ) ) {
	define( 'vlwp_updater_plugin_file', __FILE__ );
}

if ( ! defined( 'vlwp_updater_plugin_dir' ) ) {
	define( 'vlwp_updater_plugin_dir', plugin_dir_path( __FILE__ ) );
}

if ( ! defined( 'vlwp_updater_plugin_url' ) ) {
	define( 'vlwp_updater_plugin_url', plugin_dir_url( __FILE__ ) );
}

require_once vlwp_updater_plugin_dir . 'includes/class-vlwp-updater-core.php';
require_once vlwp_updater_plugin_dir . 'includes/class-vlwp-updater-hooks.php';

register_activation_hook( __FILE__, array( 'VLWP_Updater_Hooks', 'vlwp_activate' ) );
register_deactivation_hook( __FILE__, array( 'VLWP_Updater_Hooks', 'vlwp_deactivate' ) );

add_action( 'plugins_loaded', 'vlwp_updater_bootstrap' );

/**
 * Bootstrap the updater plugin.
 */
function vlwp_updater_bootstrap() {
	vlwp_load_updater_textdomain();
	VLWP_Updater_Core::vlwp_get_instance()->vlwp_init();
}

/**
 * Load plugin textdomain.
 */
function vlwp_load_updater_textdomain() {
	load_plugin_textdomain( 'vlwp-updater', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
}
