<?php
/**
 * Hooks and activation/deactivation logic.
 */

defined( 'ABSPATH' ) || exit;

class VLWP_Updater_Hooks {
	/**
	 * Activation hook.
	 */
	public static function vlwp_activate() {
		self::vlwp_register_default_options();
		self::vlwp_schedule_update_check();
	}

	/**
	 * Deactivation hook.
	 */
	public static function vlwp_deactivate() {
		$timestamp = wp_next_scheduled( 'vlwp_check_updates' );
		if ( $timestamp ) {
			wp_unschedule_event( $timestamp, 'vlwp_check_updates' );
		}
	}

	/**
	 * Register default options.
	 */
	private static function vlwp_register_default_options() {
		if ( false === get_option( 'vlwp_updater_repository_url', false ) ) {
			add_option( 'vlwp_updater_repository_url', '', '', false );
		}
		if ( false === get_option( 'vlwp_last_update_check', false ) ) {
			add_option( 'vlwp_last_update_check', 0, '', false );
		}
	}

	/**
	 * Schedule update check.
	 */
	private static function vlwp_schedule_update_check() {
		if ( ! wp_next_scheduled( 'vlwp_check_updates' ) ) {
			wp_schedule_event( time(), 'weekly', 'vlwp_check_updates' );
		}
	}
}
