<?php
/**
 * Uninstall handler for VLWP SEO plugin
 *
 * Deletes plugin-specific post meta and options when the plugin is uninstalled.
 */

if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
    exit;
}

global $wpdb;

// Meta keys used by the plugin
$meta_keys = array(
    'vlwp_seo_meta_title',
    'vlwp_seo_meta_description',
    'vlwp_seo_keywords',
    'vlwp_seo_noindex',
    'vlwp_seo_nofollow',
    'vlwp_seo_noarchive',
    'vlwp_seo_nosnippet',
);

// Remove all post meta entries for these keys
foreach ( $meta_keys as $key ) {
    // WP function that removes meta for all posts by key
    if ( function_exists( 'delete_post_meta_by_key' ) ) {
        delete_post_meta_by_key( $key );
    } else {
        $wpdb->delete( $wpdb->postmeta, array( 'meta_key' => $key ), array( '%s' ) );
    }
}

// Remove stored option for robots text (if any)
delete_option( 'vlwp_seo_robots_txt' );

// (No custom DB tables created by this plugin)

// Done.
