<?php
/**
 * Plugin Name: VLWP-SEO
 * Description: Essential SEO tools (post meta, Open Graph, canonical, robots.txt editor).
 * Version: 1.0.0
 * Author: Vitali Lutz
 * Text Domain: vlwp-seo
 * Domain Path: /languages
 */

defined( 'ABSPATH' ) || exit;

if ( ! defined( 'VLWP_SEO_VERSION' ) ) {
	define( 'VLWP_SEO_VERSION', '1.0.0' );
}

if ( ! defined( 'VLWP_SEO_DIR' ) ) {
	define( 'VLWP_SEO_DIR', plugin_dir_path( __FILE__ ) );
}

if ( ! defined( 'VLWP_SEO_URL' ) ) {
	define( 'VLWP_SEO_URL', plugin_dir_url( __FILE__ ) );
}

add_action( 'plugins_loaded', function() {
	load_plugin_textdomain( 'vlwp-seo', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
} );

require_once VLWP_SEO_DIR . 'includes/class-vlwp-seo-core.php';
require_once VLWP_SEO_DIR . 'includes/class-vlwp-seo-admin.php';

add_action( 'init', [ 'VLWP_SEO_Core', 'init' ] );
add_action( 'plugins_loaded', [ 'VLWP_SEO_Admin', 'init' ] );