<?php
defined( 'ABSPATH' ) || exit;

class VLWP_SEO_Admin {

    public static function init() {
        add_action( 'admin_init', [ __CLASS__, 'register_robots_setting' ] );
        add_action( 'admin_init', [ __CLASS__, 'maybe_save_robots' ] );
    }

    public static function register_robots_setting() {
        add_settings_section(
            'vlwp_seo_robots_section',
            __( 'Robots.txt', 'vlwp-seo' ),
            function() {
                echo '<p>' . esc_html__( "Edit the content of the robots.txt file in the site's root directory.", 'vlwp-seo' ) . '</p>';
            },
            'reading'
        );

        add_settings_field(
            'vlwp_seo_robots_txt',
            __( 'Content of robots.txt', 'vlwp-seo' ),
            [ __CLASS__, 'render_robots_field' ],
            'reading',
            'vlwp_seo_robots_section'
        );

        register_setting( 'reading', 'vlwp_seo_robots_txt', [
            'type' => 'string',
            'sanitize_callback' => null,
            'show_in_rest' => false,
        ] );
    }

    public static function render_robots_field() {
        $robots_file = ABSPATH . 'robots.txt';

        if ( file_exists( $robots_file ) && is_readable( $robots_file ) ) {
            $value = file_get_contents( $robots_file );
        } else {
            $value = '';
        }

        echo '<textarea name="vlwp_seo_robots_txt" rows="10" cols="80" style="width:100%;">' . esc_textarea( $value ) . '</textarea>';
        echo '<p class="description">' . esc_html__( 'Add custom rules to the robots.txt file to specify which areas or resources of the site should not be crawled.', 'vlwp-seo' ) . '</p>';
    }

    public static function maybe_save_robots() {
        if ( ! is_admin() ) {
            return;
        }

        if ( ! current_user_can( 'manage_options' ) ) {
            return;
        }

        if ( ! isset( $_POST['option_page'] ) || $_POST['option_page'] !== 'reading' ) {
            return;
        }

        if ( ! isset( $_POST['vlwp_seo_robots_txt'] ) ) {
            return;
        }

        // Verify nonce for reading options page
        check_admin_referer( 'reading-options' );

        $robots_content = wp_unslash( $_POST['vlwp_seo_robots_txt'] );
        $robots_content = str_replace( ["\r\n", "\r"], "\n", $robots_content );
        $robots_path = ABSPATH . 'robots.txt';

        $result = @file_put_contents( $robots_path, $robots_content );

        if ( $result === false ) {
            add_action( 'admin_notices', function() {
                echo '<div class="notice notice-error"><p>' . esc_html__( 'Failed to write to robots.txt. Please check file permissions.', 'vlwp-seo' ) . '</p></div>';
            } );
        }
    }
}
