<?php

/**
 * Plugin Name: VLWP Backup
 * Description: Comprehensive backup and restore solution for WordPress sites.
 * Author: Vitali Lutz
 * Author URI: https://vitali-lutz.de
 * Plugin URI: https://vitali-lutz.de/wordpress-plugins/backup
 * Version: 1.0.0
 * Requires at least: 6.0
 * Requires PHP: 7.4
 * Text Domain: vlwp-backup
 * Domain Path: /languages
 * License: Proprietary
 * License URI: https://vitali-lutz.de/license
 *
 * Copyright: (c) 2026 Vitali Lutz. All rights reserved.
 * This plugin is licensed under a proprietary license. You may not use, copy, modify, distribute, or sell this plugin without explicit permission from the author. For more information about the license and
 */

defined( 'ABSPATH' ) || exit;

// Fatal error helpers removed.
// - the plugin needs language support, German should be addeded as translation, the plugin should be ready for translation and include a .pot file for translators to create translations for other languages as well.
if ( ! defined( 'vlwp_backup_version' ) ) {
	define( 'vlwp_backup_version', '1.0.0' );
}
// - The plugin should also have a feature to test the backup and restore process, this can be useful for users to ensure that their backups are working correctly and can be restored without issues, the test feature should create a temporary backup and then attempt to restore it, if the restore process is successful, the user should receive a notification that the test was successful, if there are any issues during the restore process, the user should receive a notification with details about the issues encountered, this feature can help users to identify and fix any potential issues with their backup and restore process before they need to rely on their backups in a real situation.
if ( ! defined( 'vlwp_backup_plugin_file' ) ) {
	define( 'vlwp_backup_plugin_file', __FILE__ );
}
// - The plugin should also have a feature to automatically delete old backups after a certain period of time or when a certain number of backups is reached, this can help users to manage their storage space and ensure that they don't have too many old backups taking up space on their server or external storage, the user should be able to set the retention period for backups and the maximum number of backups to keep in the settings page.
if ( ! defined( 'vlwp_backup_plugin_dir' ) ) {
	define( 'vlwp_backup_plugin_dir', plugin_dir_path( __FILE__ ) );
}

if ( ! defined( 'vlwp_backup_plugin_url' ) ) {
	define( 'vlwp_backup_plugin_url', plugin_dir_url( __FILE__ ) );
}

if ( ! defined( 'vlwp_backup_option_key' ) ) {
	define( 'vlwp_backup_option_key', 'vlwp_backup_settings' );
}

if ( ! defined( 'vlwp_backup_cron_hook' ) ) {
	define( 'vlwp_backup_cron_hook', 'vlwp_backup_run_scheduled_backup' );
}

if ( ! defined( 'vlwp_backup_rebuild_indexes_cron_hook' ) ) {
	define( 'vlwp_backup_rebuild_indexes_cron_hook', 'vlwp_backup_rebuild_indexes_cron' );
}

if ( ! defined( 'vlwp_backup_logs_dir' ) ) {
	define( 'vlwp_backup_logs_dir', WP_CONTENT_DIR . '/uploads/vlwp-backup/logs' );
}

require_once vlwp_backup_plugin_dir . 'includes/class-vlwp-backup-hooks.php';
require_once vlwp_backup_plugin_dir . 'includes/class-vlwp-backup-logger.php';
require_once vlwp_backup_plugin_dir . 'includes/class-vlwp-backup-storage.php';

// Load composer autoload if available (phpseclib for SFTP)
if ( file_exists( vlwp_backup_plugin_dir . 'vendor/autoload.php' ) ) {
	require_once vlwp_backup_plugin_dir . 'vendor/autoload.php';
}

require_once vlwp_backup_plugin_dir . 'includes/class-vlwp-backup-engine.php';
require_once vlwp_backup_plugin_dir . 'includes/class-vlwp-backup-list-table.php';
require_once vlwp_backup_plugin_dir . 'includes/class-vlwp-backup-core.php';
require_once vlwp_backup_plugin_dir . 'includes/class-vlwp-backup-admin.php';

register_activation_hook( __FILE__, array( 'VLWP_Backup_Hooks', 'vlwp_activate' ) );
register_deactivation_hook( __FILE__, array( 'VLWP_Backup_Hooks', 'vlwp_deactivate' ) );

add_action( 'plugins_loaded', 'vlwp_backup_bootstrap' );

/**
 * Bootstrap plugin services.
 */
function vlwp_backup_bootstrap() {
	vlwp_backup_load_textdomain();
	VLWP_Backup_Hooks::vlwp_init();

	VLWP_Backup_Core::vlwp_get_instance()->vlwp_init();

	if ( is_admin() ) {
		VLWP_Backup_Admin::vlwp_get_instance()->vlwp_init();
	}
}

/**
 * Load plugin textdomain.
 */
function vlwp_backup_load_textdomain() {
	load_plugin_textdomain( 'vlwp-backup', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
}
